from mylib.LINKDATALinkDataCtrl7 import *
import win32com.client
import pythoncom
def leggi_entita_da_grafico():
    try:
        pythoncom.CoInitialize()
        # Connessione a Analyst's Notebook
        ANB_oggetto = win32com.client.Dispatch("LinkNotebook.Application.7")
        curr = LNChart(ANB_oggetto.CurrentChart)
        if curr is None:
            print("Nessun grafico attivo trovato. Apri un grafico in Analyst's Notebook.")
            return
        try:
            nome_file = curr.Filename  # Proprietà Filename
            print(f"Grafico attivo trovato: {nome_file}")
        except Exception:
            print("Impossibile accedere alla proprietà 'Filename'.")
        # Iterazione sulle entità
        print("Iterazione sulle entità:")
        sel = LNEntityIterator(curr.Entities(1, 0))
        for LNEntity in sel:
            print(f"Entità trovata: {LNEntity.Identity}")
            label = LNEntity.Label if hasattr(LNEntity, 'Label') else "Nessuna Label"
            print(f"  Label: {label}")
            print("Iterazione sugli attributi:")
            for i in range(LNEntity.AttributeCount):
                LNAttributeClass = LNEntity.Attributes(i)
                nome_attributo = LNAttributeClass.Name
                valore_attributo = LNEntity.AttributeValue(LNAttributeClass)
                print(f"  Attributo: {nome_attributo} -> Valore: {valore_attributo}")
    except Exception as e:
        print(f"Errore durante la lettura delle entità: {str(e)}")
    finally:
        pythoncom.CoUninitialize()
if __name__ == "__main__":
    leggi_entita_da_grafico()